% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Common.R
\name{pempirical}
\alias{pempirical}
\alias{qempirical}
\alias{rempirical}
\alias{dempirical}
\title{Cumulative probability function of empirical distribution using linear interpolation}
\usage{
pempirical(q, cdf)

qempirical(p, cdf)

rempirical(n, cdf)

dempirical(x, cdf)
}
\arguments{
\item{q}{Value of the variable}

\item{cdf}{empirical distribution (cdf for continuous distribution and pmf for discrete distribution)}

\item{p}{Value of the probability}

\item{n}{Number of samples}

\item{x}{Value of the variable}
}
\description{
Cumulative probability function of empirical distribution using linear interpolation

Quantile function of Empirical Distribution

Random generation function of Empirical Distribution

Density function of Empirical Distribution based on simulation
}
\examples{
#discrete distribution
pempirical(c(3,5,10),matrix(c(0.1,0.2,0.3,0.05,0.05,0.2,0.1,1:6,10),7,2))
#continuous distribution
pempirical(350,matrix(c(seq(0.01,1,0.01),cumprod(c(1,rep(1.1,99)))),100,2))
#discrete distribution
qempirical(c(0.3,0.65,1),matrix(c(0.1,0.2,0.3,0.05,0.05,0.2,0.1,1:6,10),7,2))
#continuous distribution
qempirical(c(0.3,0.65,0.8),matrix(c(seq(0.01,1,0.01),cumprod(c(1,rep(1.1,99)))),100,2))
#discrete distribution
rempirical(100,matrix(c(0.1,0.2,0.3,0.05,0.05,0.2,0.1,1:6,10),7,2))
#continuous distribution
rempirical(100,matrix(c(seq(0.01,1,0.01),cumprod(c(1,rep(1.1,99)))),100,2))
#discrete distribution
dempirical(3,matrix(c(0.1,0.2,0.3,0.05,0.05,0.2,0.1,1:6,10),7,2))
#continuous distribution
dempirical(30,matrix(c(seq(0.01,1,0.01),qnorm(seq(0.01,1,0.01),30,20)),100,2))
}
