% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Copula.R
\docType{methods}
\name{copulaSample}
\alias{copulaSample}
\alias{copulaSample,CopulaObj,numeric-method}
\alias{copulaSample,ANY-method}
\title{Copula sampling. It will generate correlated variables or percentiles when marginal distributions are not specified.}
\usage{
copulaSample(object, n, ...)

\S4method{copulaSample}{CopulaObj,numeric}(object, n)
}
\arguments{
\item{object}{Copula Object}

\item{n}{Number of samples}

\item{...}{Additional parameters that may or may not be used}
}
\description{
Copula sampling. It will generate correlated variables or percentiles when marginal distributions are not specified.
}
\examples{
library(cascsim)
dist1<-new("Pareto",p1=20,p2=3)
dist2<-new("Normal",p1=5,p2=3,min=0,max=20,truncated=TRUE)
nom.cop <- new("CopulaObj", param=c(0.5),marginal=list(dist1=dist1,dist2=dist2),dimension=2)
copulaSample(nom.cop,100)
}
