% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text-wrap.R
\name{text_wrap}
\alias{text_wrap}
\title{Text wrap}
\usage{
text_wrap(x, wrap)
}
\arguments{
\item{x}{A tag element or \link{.style} pronoun.}

\item{wrap}{A boolean. One of,
\itemize{
\item \code{TRUE}
\item \code{FALSE}
}}
}
\value{
An object of the same type as \code{x}.
}
\description{
The \code{text_wrap()} adjusts how text is wrapped, or not wrapped, in a tag
element.
}
\examples{

library(htmltools)

div(
  style = "width: 5rem;",
  .style \%>\%
    background_color(theme_primary()) \%>\%
    text_wrap(TRUE),
  "Wrap text to fit the element"
)

div(
  style = "width: rem;",
  .style \%>\%
    background_color(theme_secondary()) \%>\%
    text_wrap(FALSE),
  "This text won't wrap onto a new line."
)

}
\seealso{
Other text utilities: 
\code{\link{text_alignment}()},
\code{\link{text_break}()},
\code{\link{text_color}()},
\code{\link{text_decoration}()},
\code{\link{text_height}()},
\code{\link{text_selection}()},
\code{\link{text_style}()},
\code{\link{text_transform}()},
\code{\link{text_weight}()}
}
\concept{text utilities}
