% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/position-sticky.R
\name{position_sticky}
\alias{position_sticky}
\title{Sticky positioning}
\usage{
position_sticky(x, ...)
}
\arguments{
\item{x}{A tag element or \link{.style} pronoun.}

\item{...}{A character string specifying an edge. One of,
\itemize{
\item \code{"bottom"}
\item \code{"top"}

Use name-value pairs to specify \link{breakpoints}.
}}
}
\value{
An object of the same type as \code{x}.
}
\description{
Use \code{position_sticky()} to position an element at the top or bottom of the
viewport after scrolling past the element.
}
\examples{

library(htmltools)

div(
  .style \%>\%
    position_sticky(sm = "top"),
  "Sticks to the top of the viewport on small screens"
)

}
\seealso{
Other position utilities: 
\code{\link{position_centered}()},
\code{\link{position}()}
}
\concept{position utilities}
