% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flex-justify.R
\name{flex_justify}
\alias{flex_justify}
\title{Flex main axis alignment}
\usage{
flex_justify(x, ...)
}
\arguments{
\item{x}{A tag element or \link{.style} pronoun.}

\item{...}{A character string specifying the main axis alignment. One of,
\itemize{
\item \code{"start"}
\item \code{"end"}
\item \code{"center"}
\item \code{"between"}
\item \code{"around"}
\item \code{"evenly"}

Use name-value pairs to specify \link{breakpoints}.
}}
}
\value{
An object of the same type as \code{x}.
}
\description{
The \code{flex_justify()} function adjusts a tag element's main axis alignment. By
default, the main axis is the x-axis. When using \code{flex_direction("column")}
the main axis becomes the y-axis.
}
\examples{

library(htmltools)

div(
  .style \%>\%
    flex_display() \%>\%
    flex_justify("end"),
  div("Flex item"),
  div("Flex item"),
  div("Flex item")
)

}
\seealso{
Other flex utilities: 
\code{\link{flex_align}()},
\code{\link{flex_content}()},
\code{\link{flex_direction}()},
\code{\link{flex_display}()},
\code{\link{flex_wrap}()},
\code{\link{item_align}()},
\code{\link{item_fill}()},
\code{\link{item_grow}()},
\code{\link{item_order}()}
}
\concept{flex utilities}
