% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setup_simulation.R
\name{setup_statevars}
\alias{setup_statevars}
\title{State Variable Setup and Initialization
Given a \code{c4c_concept} concept definition, and a matching vector of
initial areas the state variables required for simulating the concept are set
up and initialized.}
\usage{
setup_statevars(concept_def, init_areas, detailed = FALSE)
}
\arguments{
\item{concept_def}{The concept definition of interest as a \code{c4c_object}}

\item{init_areas}{A vector providing the initial areas for the stand
development (sub) phases defined in \code{concept_def} in the same order.
In case \code{init_areas} relates to the phases, \code{detailed} must be
\code{FALSE}. If it relates directly to the subphases, \code{detailed} must
be \code{TRUE}. In the former case, the areas given for a phase are equally
divided among its subphases. The areas must be given in the same area unit
as named in \code{concept_def}, usually ha.}

\item{detailed}{Logical, \code{FALSE} (default) indicates that
\code{init_areas} is given for each stand development phase (and will be
equally distributed among the subphases). \code{TRUE} indicates that
\code{init_areas} is directly given for each subphase.}
}
\value{
A vector which is actually a sequence of three different blocks. This
format is required for simulations with \code{\link[deSolve:ode]{ode}}.
Each block has as many elements as the total number of subpbases defined in
\code{concept_def}. Each element refers to each subphase in the order of
the phase sequence. The first block, contains the initial areas attributed
to all subphases in the order of the phase sequence. The second and the
third block will track the cumulative in- and outflows of each area during
the simulation. They are initialized with 0.
}
\description{
The state variables to be created are the areas attributed to the single
stand development phases defined in the concept definition of interest. More
precisely, each subphase has an area which is a state variable. When
initializing, the intial areas can be given for each phase in
\code{init_areas}, or for each subphase. In the former case the initial phase
areas are equally divided among the respective subphases.\cr In order to
allow post-hoc reconstruction of the area flows, the function also creates
the cumulative inflows and outflows to each subphase area as state variables
and initializes them with 0.
}
\examples{
  # Initialize with phase wise initial areas
  init_areas <- c(1000, 400, 250, 125, 125, 100)
  state_vars <- pine_thinning_from_above_1 |> setup_statevars(init_areas)
  state_vars

  # Initialize with subphase wise initial areas
  # Assume, we are afforesting 1000 ha, so all area has to be initially in
  # the first subphase of the first stand development phase
  n_sub <- sum(pine_thinning_from_above_1$growth_and_yield$n_subphases)
  init_areas    <- rep(0, n_sub)
  init_areas[1] <- 1000
  state_vars    <- setup_statevars(pine_thinning_from_above_1,
                                   init_areas,
                                   detailed = TRUE)
  state_vars

}
