% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/config_precommit.R
\name{toggle_precommit_hook}
\alias{toggle_precommit_hook}
\title{Toggle pre-commit hooks}
\usage{
toggle_precommit_hook(...)
}
\arguments{
\item{...}{One or more named lists, each with fields:
\describe{
\item{\code{id}}{Character. The hook ID to toggle.}
\item{\code{enable}}{Logical. \code{TRUE} to enable the hook, \code{FALSE} to disable it. Defaults to \code{TRUE}.}
}}
}
\value{
cli messages describing the result. When disabled, the hook's \code{stages} field is set to \verb{[manual]}
so it is skipped during normal git runs. When enabled, the \code{stages} restriction is removed.
}
\description{
Enable or disable individual hooks in the \code{.pre-commit-config.y*ml} file.
}
\details{
Disabling a hook sets \verb{stages: [manual]} on the hook entry, which tells pre-commit to skip it during
normal git commits. The hook can then only be triggered explicitly with \verb{pre-commit run --hook-stage manual}.
Enabling a hook removes the \code{stages} field, restoring default behaviour.
}
\examples{
\dontrun{
toggle_precommit_hook(
  list(id = "lintr", enable = FALSE),
  list(id = "styler", enable = TRUE)
)
}

}
