% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/capl.R
\name{get_capl}
\alias{get_capl}
\title{Compute all CAPL-2 scores and interpretations at once.}
\usage{
get_capl(raw_data = NULL, sort = "asis", version = 2)
}
\arguments{
\item{raw_data}{A data frame of raw CAPL-2 data.}

\item{sort}{An optional character vector representing how the variables in the returned data frame are to be sorted (valid values are "asis, "abc"
and "zyx"; valid values are not case-sensitive). This argument is set to "asis" by default.}

\item{version}{An optional numeric (integer) vector representing the version of CAPL. This argument is set to 2 by default. If set to 1, \code{\link[=get_fill_in_the_blanks_score]{get_fill_in_the_blanks_score()}}
will ignore the when_cooling_down parameter and re-weight the score so that it's out of six.}
}
\value{
Returns a merged data frame of raw data and CAPL-2 scores and interpretations.
}
\description{
This function is the main function in the \code{capl} package. It is a wrapper function that calls all other \code{capl} functions to compute all CAPL-2 scores and
interpretations from raw data at once. If required CAPL-2 variables are missing, the function will create the variables and set values for these
variables to NA so the function can proceed.
}
\details{
Other \code{capl} functions called by this function include: \code{\link[=get_missing_capl_variables]{get_missing_capl_variables()}}, \code{\link[=get_pacer_20m_laps]{get_pacer_20m_laps()}}, \code{\link[=get_pacer_score]{get_pacer_score()}},
\code{\link[=get_capl_interpretation]{get_capl_interpretation()}}, \code{\link[=get_plank_score]{get_plank_score()}}, \code{\link[=get_camsa_time_score]{get_camsa_time_score()}}, \code{\link[=get_camsa_skill_time_score]{get_camsa_skill_time_score()}}, \code{\link[=get_camsa_score]{get_camsa_score()}}, \code{\link[=get_pc_score]{get_pc_score()}},
\code{\link[=get_capl_domain_status]{get_capl_domain_status()}}, \code{\link[=get_pedometer_wear_time]{get_pedometer_wear_time()}}, \code{\link[=validate_steps]{validate_steps()}}, \code{\link[=get_step_average]{get_step_average()}}, \code{\link[=get_step_score]{get_step_score()}},
\code{\link[=get_self_report_pa_score]{get_self_report_pa_score()}}, \code{\link[=get_db_score]{get_db_score()}}, \code{\link[=get_predilection_score]{get_predilection_score()}}, \code{\link[=get_adequacy_score]{get_adequacy_score()}},
\code{\link[=get_intrinsic_motivation_score]{get_intrinsic_motivation_score()}}, \code{\link[=get_pa_competence_score]{get_pa_competence_score()}}, \code{\link[=get_mc_score]{get_mc_score()}}, \code{\link[=get_binary_score]{get_binary_score()}}, \code{\link[=get_fill_in_the_blanks_score]{get_fill_in_the_blanks_score()}},
\code{\link[=get_ku_score]{get_ku_score()}} and \code{\link[=get_capl_score]{get_capl_score()}}
}
\examples{
get_capl(raw_data)

}
