% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_discrim.R
\name{predict_discrim}
\alias{predict_discrim}
\title{Predicted values for discriminant analysis}
\usage{
predict_discrim(
  object,
  newdata,
  prior = object$prior,
  dimen,
  scores = FALSE,
  posterior = FALSE,
  ...
)
}
\arguments{
\item{object}{An object of class \code{"lda"} or \code{"qda"}  such as results from \code{\link[MASS:lda]{MASS::lda()}} or \code{\link[MASS:qda]{MASS::qda()}}}

\item{newdata}{A data frame of cases to be classified or, if \code{object} has a formula, a data frame with columns of the same names as the variables used. A vector will be interpreted as a row vector. If \code{newdata} is missing, an attempt will be made to retrieve the data used to fit the \code{lda} object.}

\item{prior}{The prior probabilities of the classes. By default, taken to be the proportions in what was set in the
call to \code{\link[MASS:lda]{MASS::lda()}} or \code{\link[MASS:qda]{MASS::qda()}}}

\item{dimen}{The dimension of the space to be used. If this is less than the number of available dimensions,
\eqn{\min(p, ng-1)}, only the first \code{dimen} discriminant components are used.
(This argument is not yet implemented because \code{\link[MASS:qda]{MASS::qda()}} does not support this.)}

\item{scores}{A logical. If \code{TRUE}, the discriminant scores of the cases in \code{newdata} are appended as additional columns in
the the result, with names \code{LD1}, \code{LD2}, ...}

\item{posterior}{Either a logical or the character string \code{"max"}. If \code{TRUE}, the posterior probabilities for all classes
are included as columns named for the classes. If \code{FALSE}, these are omitted. If \code{"max"}, the maximum
value of the probabilities across the classes are included, with the variable name \code{"maxp"}.}

\item{...}{arguments based from or to other methods, not yet used here}
}
\value{
A \code{data.frame}, containing the the predicted class of the observations (named for the class in the model) and
values of the \code{newdata} variables. Other variables included are determined by the \code{scores} and \code{posterior} arguments.
\code{rownames()} in the result are inherited from those in \code{newdata}.
}
\description{
\code{predict_discrim} calculates predicted class membership values for a linear or quadratic discriminant analysis,
returning a \code{data.frame} suitable for graphing or other analysis.
}
\details{
The \code{predict()} methods provided for \code{\link[MASS:lda]{MASS::lda()}} and \code{\link[MASS:qda]{MASS::qda()}} are a mess, because they return their results as
a list, with components \code{class}, \code{posterior} and \code{x}. This function is designed as a wrapper on those to return
results in a more consistent and flexible way.

For use in graphs, where you want to show the classification boundaries or regions, you should supply a \code{newdata} data frame consisting
of two focal variables which are varied over their ranges, with the remaining variables used in the discriminant analysis
held fixed at typical values.

Using the \code{scores} argument, the function also returns the scores on the discriminant functions. This is only available for
linear discriminant analysis with \code{\link[MASS:lda]{MASS::lda()}}.
}
\examples{
library(candisc)
library(MASS)   # for lda()

iris.lda <- lda(Species ~ ., iris)
pred_iris <- predict_discrim(iris.lda)
names(pred_iris)

# include scores, exclude posterior
pred_iris <- predict_discrim(iris.lda, scores = TRUE, posterior = FALSE)
names(pred_iris)

data(peng, package="heplots")
peng.lda <- lda(species ~ bill_length + bill_depth + flipper_length + body_mass, 
                data = peng)
peng_pred <- predict_discrim(peng.lda, scores = TRUE)
str(peng_pred)
}
