% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callback_reg.R
\name{reg_als}
\alias{reg_als}
\title{Asymptotic least squares estimation}
\usage{
reg_als(x, y, omega, ols = FALSE)
}
\arguments{
\item{x}{the matrix of the right-hand variables (incl. the constant term when 
needed).}

\item{y}{the vector of the left-hand variable.}

\item{omega}{the covariance matrix of the disturbances.}

\item{ols}{logical indicating whether to perform OLS (TRUE) or FGLS (FALSE).
The default is FALSE.}
}
\value{
a list with class \code{reg_als} containing \code{"config"}
 for the definition of the estimation method and \code{"reg"} for the 
 estimation output.
 
The \code{"config"} data frame includes the following elements:
\itemize{
\item\bold{family: }"als" (for Asymptotic least squares).
\item\bold{method: }"ols" for Ordinary least square, or "fgls" for Feasible
generalized least squares.
}
The list \code{"reg"} includes the following elements (when relevant):
\itemize{
\item\bold{estim:}a data frame with \code{c_names} for the component names,
\code{coef}, the estimated coefficients, \code{std_coef}, the estimated 
standard errors, \code{student}the Student statistics for the equality of the 
coefficient to 0, \code{p_value}, the p-values of the asymptotic Student test. 
\item\bold{cova:} the estimated covariance matrix of the estimator.
\item\bold{over_test:}a data frame with the output of the overidentification 
test (FGLS only). The statistic is given by \code{stat}, the degrees of
freedom by \code{df} and the p-value by \code{p_value}
}
}
\description{
Asymptotic least squares estimation
}
\examples{
model <- list(c("license"),c("woman"),c("woman","license","inter"))
comp <- callback_comp(mobility1,"offer",c("gender","licenses"),"callback",model)
    x <- comp$aux_boole
    y <- comp$aux_coef
omega <- comp$aux_vcov
 
str(reg_als(x,y,omega))

}
\references{
Chamberlain, G. (1982). Multivariate regression models for panel 
data. Journal of econometrics, 18(1), 5-46.
Gourieroux, C., Monfort, A., & Trognon, A. (1985). Moindres carrés 
asymptotiques. Annales de l'INSEE, 91-122.
Kodde, D. A., Plam, F. C., & Pfann, G. A. (1990). Asymptotic least‐squares
 estimation efficiency considerations and applications. Journal of Applied 
 Econometrics, 5(3), 229-243.
}
