% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{c3_mixedGeom}
\alias{c3_mixedGeom}
\title{Mixed Geometry Plots}
\usage{
c3_mixedGeom(c3, types, type = "line", stacked = NULL)
}
\arguments{
\item{c3}{c3 htmlwidget object}

\item{types}{list containing key value pairs of column header and plot type}

\item{type}{character default plot type where not defined}

\item{stacked}{character vector of column headers to stack}
}
\value{
c3
}
\description{
Use multiple geometry types in a single plot
}
\examples{
data <- data.frame(a = abs(rnorm(20) *10),
                   b = abs(rnorm(20) *10),
                   c = abs(rnorm(20) *10),
                   d = abs(rnorm(20) *10))
data \%>\%
  c3() \%>\%
  c3_mixedGeom(type = 'bar',
               stacked = c('b','d'),
               types = list(a='area',
                            c='spline'))

}
