\name{heigh_propotion_test}
\alias{heigh_propotion_test}
\title{Cumulative denseness test}
\usage{
heigh_propotion_test(imagematrix, proportion, height_size)
}
\arguments{
\item{imagematrix}{The matrix to be analysed.}

\item{proportion}{Proportion of denseness to test.}

\item{height_size}{Real size of image height (in mm, cm, m, etc..).}
}
\description{
Find the height which a given proportion of black pixel is found.
}
\examples{
# First, get a matrix from your image. Here an example of a bush image is used.
bush<-system.file("extdata/bush.JPG",package ="bwimage")
bush_imagematrix<-threshold_color(bush,  "jpeg",  "proportional", compress_rate = 0.1)

# See the proportion of black pixels (1) below each bush image matrix row
heigh_propotion_test(bush_imagematrix,0.75,100)
# Conclusion: in this imagem, 75 percent of the vegetation is hold below 31.2 cm.
}
\references{
Zehm et al 2003 Multiparameter analysis of vertical vegetation structure based on digital image processing. Flora-Morphology, Distribution, Functional Ecology of Plants, 198: 142-160.
}
\seealso{
threshold_color
}
\author{
Carlos Biagolini-Jr.
}
