% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regularly_delayed.R
\name{regularly_delayed}
\alias{regularly_delayed}
\alias{delayed}
\title{Generate list of repeating financial transactions with delayed starting month}
\usage{
regularly_delayed(years, pa, start_month = 1)

delayed(pa, start_month = 1)
}
\arguments{
\item{years}{See \code{\link[businessPlanR:regularly]{regularly}}.}

\item{pa}{See \code{\link[businessPlanR:regularly]{regularly}}.}

\item{start_month}{Integer number,
      the month of the first revenue/expense. All earlier monthly transactions will be 0
and the sum for the respective year divided by the number months left for that year.}
}
\value{
Either a list of monthly transactions named in "YYYY.MM" scheme (\code{regularly_delayed}),
      or
   vector of the same length as \code{pa} (\code{delayed}).
}
\description{
In case you only know the annual sum of transactions for given years but also that they
don't begin in January of the first year,
      you can use the function \code{regularly_delayed} to split the sums
to be used in revenue or expense objects that acknowledge the delay.
It extends \code{\link[businessPlanR:regularly]{regularly}}.
}
\details{
The \code{delayed} function assumes \code{pa} to be a total value for a full year,
      but does not distribute it evenly
over the active months,
      but rather subtracts any amount that would have been due before \code{start_month}.
}
\examples{
# say you earn 3000 each year, but payment starts in September
# calculate payment sums
delayed_2019_2021 <- delayed(
   pa=rep(3000, 3),
   start_month=9
)

# now use the result to caclulate monthly amounts
delayed_monthly_2019_2021 <- regularly_delayed(
   years=2019:2021,
   pa=delayed_2019_2021,
   start_month=9
)
}
