% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_statistics.R
\name{calculate_statistics}
\alias{calculate_statistics}
\title{Estimate the marginal causal survival curves using potential outcome framework}
\usage{
calculate_statistics(model, trt)
}
\arguments{
\item{model}{A fitted \link[survival]{coxph} model. This should be a coxph event model or censoring model.}

\item{trt}{Character. Name of the treatment assignment variable.}
}
\value{
Two vectors containing the marginal causal survival curves for treatment arms (1 for treatment arm; 0 for control arm/placebo). Each number is the probability of the surviving the time window
(t1,t2],... conditional on surviving the prior corresponding window.
}
\description{
Estimate the marginal causal survival curves for simulating time-to-event data in a discrete manner
based on the methods from Daniel et al.(2020).
}
\details{
If the study period for the original data is divided into discrete windows,
defined by the event times in the original data, at time t0 = 0, everyone in the simulated data is still a survivor.
S(x) is the estimated survival function. By the end of the window (0,t1], a proportion S(t1) still survives.
The conditional probability of surviving the next window, (t1,t2], conditional on surviving the first window,
is S(t2)/S(t1), and so on. This function returns the S(t2)/S(t1) in series.
}
\examples{
library(survival)
data("oak")

cox_event <- coxph(Surv(OS, os.status) ~ trt + btmb + pdl1, data = oak)
calculate_statistics(model = cox_event, trt = "trt")

}
\references{
Daniel R, Zhang J, Farewell D. Making apples from oranges:
Comparing noncollapsible effect estimators and their standard errors
after adjustment for different covariate sets.
Biom J. 2021;63(3):528-557. doi:10.1002/bimj.201900297
}
