% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adapt_bewerberboerse.R
\name{bewerberboerse_search}
\alias{bewerberboerse_search}
\title{Search the Bewerberboerse API}
\usage{
bewerberboerse_search(params = list(), flatten = FALSE, flatten_mode = "json")
}
\arguments{
\item{params}{List of query parameters.}

\item{flatten}{Logical; drop nested list columns.}

\item{flatten_mode}{Flatten strategy for list columns. Use "unnest" to
expand list-columns into multiple rows.}
}
\value{
A tibble containing candidate listings with columns including
reference number, availability, location, skills, and contact flags. When
\code{flatten = FALSE}, includes nested list columns for education and
experience. Metadata columns include \code{page}, \code{size}, and \code{max_ergebnisse}.
}
\description{
Search the Bewerberboerse API
}
\details{
The Bewerberboerse API provides access to candidate listings. Authentication
uses an API key passed as \code{X-API-Key} (clientId \code{jobboerse-bewerbersuche-ui}).
See https://bundesapi.github.io/bewerberboerse-api/ for official docs.

Use \code{\link[=bunddev_auth_set]{bunddev_auth_set()}} to configure the key and \code{\link[=bunddev_parameters]{bunddev_parameters()}} to
inspect available query parameters.
}
\examples{
\dontrun{
Sys.setenv(BEWERBERBOERSE_API_KEY = "jobboerse-bewerbersuche-ui")
bunddev_auth_set("bewerberboerse", type = "api_key", env_var = "BEWERBERBOERSE_API_KEY")
bewerberboerse_search(params = list(was = "data", size = 10), flatten = TRUE)
}
}
\seealso{
\code{\link[=bewerberboerse_details]{bewerberboerse_details()}} for detailed entries and \code{\link[=bunddev_auth_set]{bunddev_auth_set()}} for
authentication setup.
}
