% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.PosteriorFEVD}
\alias{plot.PosteriorFEVD}
\title{Plots forecast error variance decompositions}
\usage{
\method{plot}{PosteriorFEVD}(
  x,
  shock_names,
  cols,
  main,
  xlab,
  mar.multi = c(1, 4.6, 0, 4.6),
  oma.multi = c(6, 0, 5, 0),
  ...
)
}
\arguments{
\item{x}{an object of class PosteriorFEVD obtained using the
\code{compute_variance_decompositions()} function containing posterior draws of 
forecast error variance decompositions.}

\item{shock_names}{a vector of length \code{N} containing names of the structural shocks.}

\item{cols}{an \code{N}-vector with colours of the plot}

\item{main}{an alternative main title for the plot}

\item{xlab}{an alternative x-axis label for the plot}

\item{mar.multi}{the default \code{mar} argument setting in \code{graphics::par}. Modify with care!}

\item{oma.multi}{the default \code{oma} argument setting in \code{graphics::par}. Modify with care!}

\item{...}{additional arguments affecting the summary produced.}
}
\description{
Plots of the posterior means of the forecast error variance 
decompositions.
}
\examples{
data(us_fiscal_lsuw)                                  # upload data
set.seed(123)                                         # set seed
specification  = specify_bsvar$new(us_fiscal_lsuw)    # specify model
burn_in        = estimate(specification, 10)          # run the burn-in
posterior      = estimate(burn_in, 20, thin = 1)      # estimate the model

# compute forecast error variance decompositions
fevd           = compute_variance_decompositions(posterior, horizon = 4)
plot(fevd)

# workflow with the pipe |>
############################################################
set.seed(123)
us_fiscal_lsuw |>
  specify_bsvar$new() |>
  estimate(S = 10) |> 
  estimate(S = 20, thin = 1) |> 
  compute_variance_decompositions(horizon = 4) |>
  plot()

}
\seealso{
\code{\link{compute_variance_decompositions}}
}
\author{
Tomasz Woźniak \email{wozniak.tom@pm.me}
}
