% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/useful-items.R
\name{productList}
\alias{productList}
\alias{productListItem}
\title{AdminLTE3 product list container}
\usage{
productList(...)

productListItem(..., image = NULL, title = NULL, subtitle = NULL, color = NULL)
}
\arguments{
\item{...}{product description.}

\item{image}{image url, if any.}

\item{title}{product name.}

\item{subtitle}{product price.}

\item{color}{price color. Valid color are listed below:
\itemize{
\item \code{primary}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#007bff")}.
\item \code{secondary}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#6c757d")}.
\item \code{info}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#17a2b8")}.
\item \code{success}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#28a745")}.
\item \code{warning}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#ffc107")}.
\item \code{danger}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#dc3545")}.
}}
}
\description{
\link{productList} creates a container to display commercial items in an elegant container.
Insert in a \link{box}.

\link{productListItem} creates a product item to insert in \link{productList}.
}
\examples{

# Box with productList
if (interactive()) {
 library(shiny)
 library(bs4Dash)

 shinyApp(
  ui = dashboardPage(
    dashboardHeader(),
    dashboardSidebar(),
    dashboardBody(
     box(
      title = "Product List",
      status = "primary",
      productList(
        productListItem(
          image = "https://www.pngmart.com/files/1/Haier-TV-PNG.png",
          title = "Samsung TV",
          subtitle = "$1800",
          color = "warning",
          "This is an amazing TV, but I don't like TV!"
        ),
        productListItem(
          image = "https://upload.wikimedia.org/wikipedia/commons/7/77/IMac_Pro.svg",
          title = "Imac 27",
          subtitle = "$4999",
          color = "danger",
          "This is were I spend most of my time!"
        )
      )
     )
    ),
    title = "Product List"
  ),
  server = function(input, output) { }
 )
}

}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
