% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nearests.R
\name{near_quantile}
\alias{near_quantile}
\title{Which values are nearest to any given quantiles}
\usage{
near_quantile(x, probs, tol = 0.01)
}
\arguments{
\item{x}{vector}

\item{probs}{quantiles to calculate}

\item{tol}{tolerance in terms of x that you will accept near to the
quantile. Default is 0.01.}
}
\value{
logical vector of TRUE/FALSE if number is close to a quantile
}
\description{
Which values are nearest to any given quantiles
}
\examples{
x <- runif(20)
near_quantile(x, 0.5, 0.05)
near_quantile(x, c(0.25, 0.5, 0.75), 0.05)

library(dplyr)
heights \%>\%
  features(height_cm, list(min = min)) \%>\%
  mutate(min_near_median = near_quantile(min, 0.5, 0.01)) \%>\%
  filter(min_near_median)
heights \%>\%
  features(height_cm, list(min = min)) \%>\%
  mutate(min_near_q3 = near_quantile(min, c(0.25, 0.5, 0.75), 0.01)) \%>\%
  filter(min_near_q3)
}
