% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_file.R, R/read_file_raw.R
\name{read_file}
\alias{read_file}
\alias{read_file_raw}
\title{Read an entire file}
\usage{
read_file(path)

read_file_raw(path)
}
\arguments{
\item{path}{A character string of the path to the file to read.}
}
\value{
\itemize{
\item \code{\link[=read_file]{read_file()}}: A length 1 character vector.
\item \code{\link[=read_file_raw]{read_file_raw()}}: A raw vector.
}
}
\description{
\code{read_file()} reads an entire file into a single character vector.
\code{read_file_raw()} reads an entire file into a raw vector.
}
\details{
\code{read_file()} assumes the file has a UTF-8 encoding.
}
\examples{
authors_file <- file.path(R.home("doc"), "AUTHORS")
data <- read_file(authors_file)
data_raw <- read_file_raw(authors_file)
identical(data, rawToChar(data_raw))
}
