% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculators.R
\name{calc_future_value_ext}
\alias{calc_future_value_ext}
\title{Future Value Extended (with periodic payments)}
\usage{
calc_future_value_ext(pv, rate, n, pmt = 0, type = 0)
}
\arguments{
\item{pv}{Present value.}

\item{rate}{Interest rate per period (decimal).}

\item{n}{Number of periods.}

\item{pmt}{Periodic payment (default = 0).}

\item{type}{Payment timing: 0 for end of period (ordinary annuity),
1 for beginning of period (annuity due).}
}
\value{
Future value.
}
\description{
Calculates the future value with optional periodic payments.
}
\examples{
calc_future_value_ext(pv = 1000, rate = 0.05, n = 10, pmt = 100)
calc_future_value_ext(pv = 0, rate = 0.01, n = 12, pmt = 500, type = 1)

}
