% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pSizeAtGenSwitch1.R
\name{pSizeAtGenSwitch1}
\alias{pSizeAtGenSwitch1}
\title{Probability that n initial cases lead to an outbreak that lasts at least g generations
of transmission AND has exactly j total cases after generation g, with offspring
distribution parameters switched after generation one}
\usage{
pSizeAtGenSwitch1(g, n, j, R0, k0, Rc, kc)
}
\arguments{
\item{g}{Number of generations of transmission}

\item{n}{Number of initial cases}

\item{j}{Total size of outbreak after generation g}

\item{R0}{Basic reproduction number: mean of negative binomial offspring distribution from generation one}

\item{k0}{Dispersion parameter of negative binomial offspring distribution from generation one}

\item{Rc}{Control reproduction number: mean of negative binomial offspring distribution from generation two plus}

\item{kc}{Dispersion parameter of negative binomial offspring distribution from generation two plus}
}
\value{
The probability of the given outbreak size at the given transmission generation
}
\description{
Probability that n initial cases lead to an outbreak that lasts at least g generations
of transmission AND has exactly j total cases after generation g, with offspring
distribution parameters switched after generation one
}
\examples{
#Probability that 10 initial cases leads to an outbreak lasting at least
# 3 transmission generations and is of exact size 30 after 3 generations  
pSizeAtGenSwitch1(g=3,n=10,j=30,R0=2,k0=0.5,Rc=0.5,kc=1)
}
\author{
Damon Toth
}
