% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glm_randomise.R
\name{randomise}
\alias{randomise}
\alias{partition}
\alias{randomise_3d}
\title{GLM non-parametric permutation testing}
\usage{
partition(M, contrast, part.method = c("beckmann", "guttman", "ridgway"))

randomise(
  perm.method,
  part.method,
  N,
  perms,
  X,
  y,
  contrasts,
  ctype,
  nC,
  skip = NULL,
  n = dim(X)[1L],
  p = qr.default(X)$rank,
  ny = dim(y)[2L],
  dfR = n - p
)

randomise_3d(
  perm.method,
  part.method,
  N,
  perms,
  X,
  y,
  contrasts,
  ctype,
  nC,
  runX = dimnames(X)[[3L]],
  n = dim(X)[1L],
  p = qr.default(X[, , 1L])$rank,
  ny = length(runX),
  dfR = n - p
)
}
\arguments{
\item{M}{Numeric matrix or array of the full design matrix(es)}

\item{contrast}{For \code{partition}, a numeric matrix with 1 or more rows
(for T and F contrasts, respectively) representing a \emph{single
contrast}.}

\item{part.method}{Character string; the method of partitioning the design
matrix into covariates of interest and nuisance. Default: \code{'beckmann'}}

\item{perm.method}{Character string indicating the permutation method.
Default: \code{'freedmanLane'}}

\item{N}{Integer; number of permutations to create. Default: \code{5e3}}

\item{perms}{Matrix of permutations, if you would like to provide your own.
Default: \code{NULL}}

\item{X}{Numeric matrix or 3D array of the design matrix(es)}

\item{y}{Numeric matrix of outcome variables, with 1 column per region, or a
single column if there is a different design matrix per region}

\item{contrasts}{Numeric matrix (for T statistics) or list of matrices (for F
statistics) specifying the contrast(s) of interest; if only one contrast is
desired, you can supply a vector (for T statistics)}

\item{ctype}{The contrast type}

\item{nC}{Integer; the number of contrasts}

\item{skip}{Integer vector indicating which (if any) contrasts to skip. Only
used by \code{\link{NBS}}.}

\item{n, p, ny, dfR}{Integers for the number of observations, design matrix
columns (its rank), number of regions/outcome variables, and residual
degrees of freedom, respectively}

\item{runX}{Character vector of regions with non-singular designs}
}
\value{
\code{partition} returns a list containing:
  \item{Mp}{Numeric array; the combined partitioned arrays}
  \item{X}{Numeric array for the covariates of interest}
  \item{Z}{Numeric array for the nuisance covariates}
  \item{eCm}{The \emph{effective contrast}, equivalent to the original, for
    the partitioned model \code{[X, Z]} and considering all covariates}
  \item{eCx}{Same as \code{eCm}, but considering only \code{X}}

A numeric array with dimensions \eqn{n_y \times N \times n_c};
  the number of rows equals number of regions/outcome variables, number of
  columns equals \code{N}, and the 3rd dimension is the number of contrasts
}
\description{
\code{randomise} and \code{randomise_3d} perform non-parametric permutation
testing for analyses in which there is a single or multiple design matrix per
region, respectively. In the latter case, \code{X} should be a 3D array.

\code{partition} partitions a full design matrix into separate matrices of
covariates of interest and nuisance covariates based on a given contrast and
partition method.
}
\section{Model partitioning}{

Consider the matrix formulation of the \emph{general linear model}:
\deqn{\mathbf{Y} = \mathbf{M} \psi + \in}
where \eqn{Y} is the vector of outcomes, \eqn{M} is the full design matrix
(including nuisance covariates), \eqn{\psi} is the vector of parameter
estimates, and \eqn{\in} is the vector of error terms. In a permutation
framework, algorithms are applied differently depending on the
presence/absence of nuisance covariates; thus the model is separated
depending on the contrast of interest:
\deqn{\mathbf{Y} = \mathbf{X}\beta + \mathbf{Z}\gamma + \in}
where \eqn{\mathbf{X}} contains covariates of interest, \eqn{\mathbf{Z}}
contains nuisance covariates, and \eqn{\beta} and \eqn{\gamma} are the
associated parameter estimates.

The manner of partitioning depends on the method. For example, for the
\code{guttman} method, \code{X} is formed from the columns of \code{contrast}
that have non-zero entries.
}

\section{Permutation methods}{

The permutation methods can be split into 2 groups, depending on which part
of the model they permute. For full details, see \emph{Winkler et al., 2014}.
\describe{
  \item{Permute Y}{Freedman-Lane, Manly, and ter Braak}
  \item{Permute X}{Smith, Draper-Stoneman, and Still-White}
}

Depending on the size of the data, it may be faster to use a method that
permutes \code{Y} instead of \code{X}. For example, in \code{\link{NBS}} with
dense matrices (more than 400-500 edges), it will be somewhat faster to use
the \dQuote{Smith} method compared to \dQuote{Freedman-Lane}. If using
\code{\link{brainGraph_GLM}}, the number of vertices follows the same
relationship.

Furthermore, all methods except Still-White include the \code{Z} (nuisance
covariate) matrix when calculating the permuted statistics.
}

\references{
Beckmann, C.F. and Jenkinson, M. and Smith, S.M. (2001) General
  multi-level linear modelling for group analysis in FMRI. Tech Rep.
  University of Oxford, Oxford.

Guttman, I. (1982) \emph{Linear Models: An Introduction}. Wiley,
  New York.

Ridgway, G.R. (2009) Statistical analysis for longitudinal MR
  imaging of dementia. PhD thesis.

Draper, N.R. and Stoneman, D.M. (1966) Testing for the inclusion
  of variables in linear regression by a randomisation technique.
  \emph{Technometrics}. \bold{8(4)}, 695--699.

Freedman, D. and Lane, D. (1983) A nonstochastic interpretation
  of reported significance levels. \emph{J Bus Econ Stat}, \bold{1(4)},
  292--298. \doi{10.1080/07350015.1983.10509354}

Manly B.F.J. (1986) Randomization and regression methods for
  testing for associations with geographical, environmental, and biological
  distances between populations. \emph{Res Popul Ecol}. \bold{28(2)},
  201--218.

Nichols, T.E. and Holmes, A.P. (2001) Nonparametric permutation
  tests for functional neuroimaging: A primer with examples. \emph{Human
  Brain Mapping}. \bold{15(1)}, 1--25.
  \doi{10.1002/hbm.1058}

Smith, S.M. and Jenkinson, M. and Beckmann, C. and Miller, K. and
  Woolrich, M. (2007) Meaningful design and contrast estimability in fMRI.
  \emph{NeuroImage}. \bold{34(1)}, 127--36.
  \doi{10.1016/j.neuroimage.2006.09.019}

Still, A.W. and White, A.P. (1981) The approximate randomization
  test as an alternative to the F test in analysis of variance. \emph{Br J
  Math Stat Psychol}. \bold{34(2)}, 243--252.

ter Braak, C.J.F. 1992. Permutation versus bootstrap significance
  tests in multiple regression and ANOVA. \emph{Bootstrapping and related
  techniques}. Springer, Berlin, Heidelberg. 79--85.

Winkler, A.M. and Ridgway, G.R. and Webster, M.A. and Smith, S.M.
  and Nichols, T.E. (2014) Permutation inference for the general linear
  model. \emph{NeuroImage}. \bold{92}, 381--397.
  \doi{10.1016/j.neuroimage.2014.01.060}
}
