% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/double_elim.R
\name{double_elim}
\alias{double_elim}
\title{Create a double elimination bracket}
\usage{
double_elim(participants, ...)
}
\arguments{
\item{participants}{Character vector of participant names, or a data.frame
with a 'name' column and optional 'seed' column.}

\item{...}{Additional arguments passed to bracket constructors or
tournament stage-verb dispatch methods.}
}
\value{
A double_elim_bracket object
}
\description{
Double elimination tournament with winners and losers brackets.
}
\examples{
# Double elimination bracket (two losses to be eliminated)
trn <- tournament(paste("Team", LETTERS[1:8])) |>
  double_elim("bracket")

# After Swiss rounds
trn <- tournament(paste("Team", LETTERS[1:16])) |>
  swiss("open", rounds = 4) |>
  double_elim("playoffs", take = top_n(8))
}
