% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.PosteriorFEVDPANEL}
\alias{summary.PosteriorFEVDPANEL}
\title{Provides posterior summary of forecast error variance decompositions}
\usage{
\method{summary}{PosteriorFEVDPANEL}(object, which_c, ...)
}
\arguments{
\item{object}{an object of class \code{PosteriorFEVDPANEL} obtained using the
\code{compute_variance_decompositions()} function containing draws from the 
posterior distribution of the forecast error variance decompositions.}

\item{which_c}{a positive integer or a character string specifying the country 
for which the forecast should be plotted.}

\item{...}{additional arguments affecting the summary produced.}
}
\value{
A list reporting the posterior mean of the forecast error variance 
decompositions of each variable at all horizons.
}
\description{
Provides posterior means of the forecast error variance 
decompositions of each variable at all horizons.
}
\examples{
# specify the model and set seed
specification  = specify_bvarPANEL$new(ilo_dynamic_panel[1:5], p = 1)

# run the burn-in
burn_in        = estimate(specification, 5)

# estimate the model
posterior      = estimate(burn_in, 5)

# compute forecast error variance decomposition 4 years ahead
fevd           = compute_variance_decompositions(posterior, horizon = 4)
summary(fevd, which_c = "ARG")

}
\seealso{
\code{\link{compute_variance_decompositions.PosteriorBVARPANEL}}, \code{\link{plot}}
}
\author{
Tomasz Woźniak \email{wozniak.tom@pm.me}
}
