% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forecast_performance.R
\name{forecast_poos_recursively}
\alias{forecast_poos_recursively}
\title{Bayesian recursive pseudo-out-of-sample forecasting}
\usage{
forecast_poos_recursively(model_spec, poos_spec, show_progress = TRUE)
}
\arguments{
\item{model_spec}{an object generated using one of the \code{specify_*} 
functions containing model specification.}

\item{poos_spec}{an object of class \code{POOSForecastSetup} containing
specification of the recursive pseudo-out-of-sample forecasting exercise 
using expanding window samples.}

\item{show_progress}{a logical value, if \code{TRUE} the estimation progress bar is visible}
}
\value{
An object of class \code{ForecastsPOOS} containing the outcome of Bayesian
 recursive pseudo-out-of-sample forecasting exercise  using expanding window 
 samples. The object is a list with \code{forecasting_sample} elements, where
 \code{forecasting_sample} is equal to the sample size less the maximum of
 \code{horizons} and the \code{training_sample} plus one. Each element of the
 list is an object of class \code{ForecastsPANEL} containing the forecasts for 
 each country, see \code{\link{forecast.PosteriorBVARPANEL}}.
}
\description{
Performs the recursive pseudo-out-of-sample forecasting exercise
using expanding window samples.
}
\examples{
spec = specify_bvarPANEL$new(ilo_dynamic_panel[1:5])   # specify the model
poos = specify_poosf_exercise$new(                # specify the forecasting exercise
         spec, 
         S = 5,                                   # use at least S = 5000
         S_burn = 2,                              # use at least S_burn = 1000
         horizons = 1,
         training_sample = 30
       )   
fore = forecast_poos_recursively(spec, poos)      # execute the forecasting exercise

}
\seealso{
\code{\link{forecast.PosteriorBVARPANEL}}, \code{\link{specify_bvarPANEL}},
\code{\link{specify_poosf_exercise}}, \code{\link{estimate.BVARPANEL}}
}
\author{
Tomasz Woźniak \email{wozniak.tom@pm.me}
}
