% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootLR.R
\name{diagCI}
\alias{diagCI}
\title{Compute values and confidence intervals for sensitivity, specificity, positive likelihood ratio, negative likelihood ratio for a single 2x2 table}
\usage{
diagCI(truePos, totalDzPos, trueNeg, totalDzNeg,
  calcLRCI = "BayesianLR.test", alpha = 0.05, binomMethod = "wilson",
  ...)
}
\arguments{
\item{truePos}{The number of true positive tests.}

\item{totalDzPos}{The total number of positives ("sick") in the population.}

\item{trueNeg}{The number of true negatives in the population.}

\item{totalDzNeg}{The total number of negatives ("well") in the population.}

\item{calcLRCI}{Method to use to calculate the LR CI: "BayesianLR.test" "none" or "analytic"}

\item{alpha}{The alpha for the width of the confidence interval (defaults to alpha = 0.05 for a 95 percent CI)}

\item{binomMethod}{The method to be passed to binom.confint to calculate confidence intervals of proportions (sensitivity, etc.).  See help("binom.confint") and the Newcombe article referenced below.}

\item{\dots}{Arguments to pass to Bayesian.LRtest.}
}
\value{
A matrix containing sensitivity, specificity, posLR, negLR results and their confidence intervals
}
\description{
Compute values and confidence intervals for sensitivity, specificity, positive likelihood ratio, negative likelihood ratio for a single 2x2 table
}
\examples{
\dontrun{
diagCI( 25, 50, 45, 75 )
diagCI( truePos = c(25, 30), totalDzPos = c( 50, 55 ), trueNeg = c(5, 35), totalDzNeg = c(60,65) )
}
}
\references{
Deeks JJ, Altman DG. BMJ. 2004 July 17; 329(7458): 168-169. Newcombe RG. Statist Med. 1998; 17(857-872).
}
