% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internalFunctions.R
\name{identifyExpPars}
\alias{identifyExpPars}
\title{Determine the parameters of the best-fit exponential distribution for a given confidence interval.}
\usage{
identifyExpPars(qLow, qUpp, alpha = 0.05, initPars = 1, maxiter = 1000)
}
\arguments{
\item{qLow}{The observed lower quantile.}

\item{qUpp}{The observed upper quantile.}

\item{alpha}{The confidence level; i.e. the desired coverage is 1-alpha. Defaults to 0.05.}

\item{initPars}{A single number giving the initial parameter value to start the optimisation; defaults to 1.}

\item{maxiter}{Maximum number of iterations for \code{optim}. Defaults to 1e3. Set to higher values if convergence problems are reported.}
}
\value{
A single number giving the rate parameter for use with rexp/dexp/pexp/qexp.
}
\description{
Finds the best-fit exponential distribution parameter for a given confidence interval and returns the rate parameter.
}
\seealso{
\code{\link{ssExpPars}}, \code{\link{optim}}, \code{\link{dexp}}
}
