% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjustPrevalence.R
\name{adjPrevSensSpecCI}
\alias{adjPrevSensSpecCI}
\title{Adjust a prevalence point estimate and confidence interval for a given assay sensitivity and specificity (also known only imprecisely).}
\usage{
adjPrevSensSpecCI(
  prevCI,
  sensCI,
  specCI,
  N = 1e+06,
  method = "hdi",
  alpha = 0.05,
  Sigma = NULL,
  doPlot = FALSE,
  prev = NULL,
  sens = NULL,
  spec = NULL,
  ylim = NULL,
  returnBootVals = FALSE,
  seed = NULL
)
}
\arguments{
\item{prevCI}{A vector of length 2 giving the lower and upper bounds of the confidence interval for the prevalence estimate.}

\item{sensCI}{A vector of length 2 giving the lower and upper bounds of the confidence interval for the assay sensitivity estimate.}

\item{specCI}{A vector of length 2 giving the lower and upper bounds of the confidence interval for the assay specificity estimate.}

\item{N}{A (large) integer giving the number of parametric bootstrap samples to take. Defaults to 1e6.}

\item{method}{The method uses to derive a confidence interval from the empirical distribution of the combined parameter. Needs to be one of 'hdi' (default; computes the highest density interval) or 'quantile (uses quantiles to derive the confidence interval).}

\item{alpha}{The desired confidence level; i.e. the returned confidence interval will have coverage 1-alpha.}

\item{Sigma}{Set to NULL if parameters are assumed to be independent (the default). If specified, this needs to be a valid 3x3 covariance matrix for a multivariate normal distribution with variances equal to 1 for all variables (in other words, this really is a correlation matrix).}

\item{doPlot}{Logical; indicates whether a graph should be produced showing the input estimated distributions for the prevalence, sensitivity and specificity estimates and the resulting empirical distribution of the adjusted prevalence together with the reported confidence interval. Defaults to FALSE.}

\item{prev}{Optional; if not NULL, and parameters \code{sens} and \code{spec} are also not NULL, then an adjusted point estimate will also be calculated.}

\item{sens}{Optional; if not NULL, and parameters \code{prev} and \code{spec} are also not NULL, then an adjusted point estimate will also be calculated.}

\item{spec}{Optional; if not NULL, and parameters \code{prev} and \code{sens} are also not NULL, then an adjusted point estimate will also be calculated.}

\item{ylim}{Optional; a vector of length 2, giving the vertical limits for the top panel of the produced plot. Only used if \code{doPlot} is set to \code{TRUE}.}

\item{returnBootVals}{Logical; if TRUE then the parameter values computed from the bootstrapped input parameter values will be returned; values for the individual parameters will be reported as a second list element; defaults to FALSE.}

\item{seed}{If desired a random seed can be specified so that the same results can be reproduced (this gets passed to function \code{bootComb}).}
}
\value{
A list object with 4 elements:
\item{estimate}{The adjusted prevalence point estimate (only non-NULL if \code{prev}, \code{sens} and \code{spec} are specified).}
\item{conf.int}{The confidence interval for the adjusted prevalence.}
\item{bootstrapValues}{A vector containing the bootstrapped adjusted prevalence values from the bootstrap samples of the input parameters. (Only non-NULL if \code{returnBootVals} is set to TRUE.)}
\item{bootstrapValuesInput}{A list where each element is the vector of the bootstrapped values for the corresponding input parameters (prevalence, sensitivity, specificity). This can be useful to check the dependence structure that was specified. (Only non-NULL if \code{returnBootVals} is set to TRUE.)}
}
\description{
This function takes as input a prevalence confidence interval, a sensitivity confidence interval and a specificity confidence interval and returns a confidence interval with the desired coverage of the adjusted prevalence.
Optionally the point estimates of prevalence, sensitivity and specificity can also be specified and, if so, these will be returned together with the confidence interval.
This function will automatically replace impossible point estimate values with 0 (if estimate <0) or 1 (if estimate >1) and also update the lower, repsectively upper confidence interval limit in this case.
}
\examples{
adjPrevSensSpecCI(
  prevCI=binom.test(x=84,n=500)$conf.int,
  sensCI=binom.test(x=238,n=270)$conf.int,
  specCI=binom.test(x=82,n=88)$conf.int,
  doPlot=TRUE,
  prev=84/500,
  sens=238/270,
  spec=82/88)

}
\seealso{
\code{\link{bootComb}}, \code{\link{adjPrevSensSpec}}, \code{\link{identifyBetaPars}}, \code{\link{dbeta}}, \code{\link[HDInterval]{hdi}}
}
