% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/d06_percentChangePVFullPrice.R
\name{estimatedPercentChangePVFullPrice}
\alias{estimatedPercentChangePVFullPrice}
\title{Calculates the percentage change in Full Price of the Bond for a given a change in its Yield-To-Maturity and Modified Duration statistic.}
\usage{
estimatedPercentChangePVFullPrice(annualModifDuration, changeInAnnualYtm)
}
\arguments{
\item{annualModifDuration}{A number.}

\item{changeInAnnualYtm}{A number.}
}
\value{
Input values to two arguments  \code{annualModifDuration}  and \code{changeInAnnualYtm}.
}
\description{
Calculates the percentage change in Full Price of the Bond for a given a change in its Yield-To-Maturity and Modified Duration statistic.
}
\details{
According to information provided by Adams and Smith (2019), the method \code{estimatedPercentChangePVFullPrice()} is developed to calculate the percentage change in Full Price of the Bond for a given a change in its Yield-To-Maturity and Modified Duration statistic.
}
\examples{
estimatedPercentChangePVFullPrice(annualModifDuration=6.126829,changeInAnnualYtm=0.01)
estimatedPercentChangePVFullPrice(annualModifDuration=6.3432,changeInAnnualYtm=-0.01)
}
\references{
Adams,J.F. & Smith,D.J.(2019). Understanding Fixed‑Income Risk and Return. In CFA Program Curriculum 2020 Level I Volumes 1-6. (Vol. 5, pp. 237-299). Wiley Professional Development (P&T). ISBN 9781119593577, \url{https://bookshelf.vitalsource.com/books/9781119593577}
}
\author{
MaheshP Kumar, \email{maheshparamjitkumar@gmail.com}
}
