% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/40_computingZspread.R
\name{computingZspread}
\alias{computingZspread}
\title{Calculates Z-Spread.}
\usage{
computingZspread(coupons, mv, bondPv, n, spots)
}
\arguments{
\item{coupons}{A number.}

\item{mv}{A number.}

\item{bondPv}{A number.}

\item{n}{A number.}

\item{spots}{A vector.}
}
\value{
Input values to five arguments  \code{coupons} ,\code{mv},\code{bondPv}, \code{n} and \code{spots}.
}
\description{
Calculates Z-Spread.
}
\details{
In fixed-income security analysis, it is important to understand why bond prices and yields-to-maturity change. In this context, it is useful to separate a yield-to-maturity into two components: the benchmark and the spread. The benchmark yield for a fixed-income security with a given time-to-maturity is the base rate which is often a government bond yield. The spread is the difference between the yield-to-maturity and the benchmark. So a Z-spread (zero-volatility spread) is based on the all benchmark spot rates taken from the spot curve. It is the constant spread that is added to each spot rate such that the present value of the cash flows matches the price of the bond (Adams & Smith, 2019).
According to information provided by Adams and Smith (2019), the method \code{computingZspread()} is developed to calculate Z-Spread based on the entire benchmark spot curve. Here, \code{coupons} stands for dollar value of the Coupon Payment, \code{mv} is maturity value of the bond, \code{bondPv} is present value or price of the bond, \code{n} is number of years, and \code{spots} is vector of spot rates taken from the spots curve. An output with the value 0.0234 means Z-Spread of 234 bps.
}
\examples{
computingZspread(coupons=5,mv=100, bondPv=92.38,n=3,spots=c(0.0486,0.0495,0.0565))
computingZspread(coupons=50,mv=1000,bondPv=923.8,n=3,spots=c(0.0486,0.0495,0.0565))
computingZspread(coupons= 6,mv=100,bondPv=100.75,n=2,spots=c(0.021,0.03635))
}
\references{
Adams,J.F. & Smith,D.J.(2019). Introduction to fixed-income valuation. In CFA Program Curriculum 2020 Level I Volumes 1-6. (Vol. 5, pp. 107-151). Wiley Professional Development (P&T). ISBN 9781119593577, \url{https://bookshelf.vitalsource.com/books/9781119593577}
}
\author{
MaheshP Kumar, \email{maheshparamjitkumar@gmail.com}
}
