## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  eval = FALSE  # Don't evaluate code in vignette building
)

## ----setup--------------------------------------------------------------------
# library(boilerplate)

## ----init---------------------------------------------------------------------
# # Use a project-specific directory
# # For this example, using a temporary directory
# data_path <- file.path(tempdir(), "quarto_example")
# 
# # Initialise all databases
# boilerplate_init(
#   data_path = data_path,
#   create_dirs = TRUE,
#   create_empty = FALSE,  # Load default content
#   confirm = FALSE,
#   quiet = TRUE
# )

## ----methods-templates--------------------------------------------------------
# # Import database first
# db <- boilerplate_import(data_path = data_path, quiet = TRUE)
# 
# # Add participant recruitment template to the unified database
# db <- boilerplate_add_entry(
#   db,
#   path = "methods.participants.recruitment",
#   value = "We recruited {{n_participants}} participants through {{recruitment_method}}.",
#   category = "methods"
# )
# 
# # Save the updated database
# boilerplate_save(db, data_path = data_path, confirm = FALSE, quiet = TRUE)

## ----measures-templates-------------------------------------------------------
# # Add a measure to the unified database
# db$measures$gad7 <- list(
#   name = "GAD-7",
#   description = "Generalized Anxiety Disorder 7-item scale",
#   type = "ordinal",  # Required field
#   items = list(
#     "Feeling nervous, anxious, or on edge",
#     "Not being able to stop or control worrying"
#   ),
#   reference = "@spitzer2006"
# )
# 
# # Save the updated database
# boilerplate_save(db, data_path = data_path, confirm = FALSE, quiet = TRUE)

## ----quarto-example-----------------------------------------------------------
# # Import database (using the temp path from above)
# db <- boilerplate_import(data_path = data_path, quiet = TRUE)
# 
# # Generate methods text
# methods_text <- boilerplate_generate_text(
#   category = "methods",
#   sections = "participants.recruitment",
#   global_vars = list(
#     n_participants = 250,
#     recruitment_method = "online panels"
#   ),
#   db = db,
#   quiet = TRUE
# )
# 
# # Output: "We recruited 250 participants through online panels."

## ----bibliography-setup-------------------------------------------------------
# # Add bibliography information to your database
# db <- boilerplate_import(data_path = data_path, quiet = TRUE)
# 
# # Using the example bibliography included with the package
# example_bib <- system.file("extdata", "example_references.bib", package = "boilerplate")
# db <- boilerplate_add_bibliography(
#   db,
#   url = paste0("file://", example_bib),
#   local_path = "references.bib"
# )
# 
# # Save the updated database
# boilerplate_save(db, data_path = data_path, confirm = FALSE, quiet = TRUE)

## ----bibliography-copy--------------------------------------------------------
# # Generate text and copy bibliography
# methods_text <- boilerplate_generate_text(
#   category = "methods",
#   sections = "statistical.default",  # Use existing section
#   db = db,
#   copy_bibliography = TRUE,
#   bibliography_path = "manuscript/"  # Copy to manuscript directory
# )

## ----validate-citations-------------------------------------------------------
# # Validate references
# validation <- boilerplate_validate_references(db)
# 
# if (!validation$valid) {
#   warning("Missing references: ", paste(validation$missing, collapse = ", "))
# }

## ----batch-ops----------------------------------------------------------------
# # Update all methods entries
# db <- boilerplate_import(data_path = data_path, quiet = TRUE)
# 
# boilerplate_batch_edit(
#   db = db$methods,
#   field = "text",
#   new_value = function(text) gsub("old text", "new text", text),
#   target_entries = "*",
#   preview = TRUE  # Preview changes first
# )

## ----params-example-----------------------------------------------------------
# methods_text <- boilerplate_generate_text(
#   category = "methods",
#   sections = "participants",
#   global_vars = list(
#     n_participants = params$n_participants,
#     study_name = params$study_name
#   ),
#   db = db
# )

