% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_p_subpops.R
\name{draw_p_subpops}
\alias{draw_p_subpops}
\title{Draw allele frequencies for independent subpopulations}
\usage{
draw_p_subpops(p_anc, inbr_subpops, m_loci = NA, k_subpops = NA)
}
\arguments{
\item{p_anc}{The scalar or length-\code{m_loci} vector of ancestral allele frequencies per locus.}

\item{inbr_subpops}{The scalar or length-\code{k_subpops} vector of subpopulation FST values.}

\item{m_loci}{If \code{p_anc} is scalar, optionally provide the desired number of loci (lest only one locus be simulated).
Stops if both \code{length(p_anc) > 1} and \code{m_loci} is not \code{NA} and they disagree.}

\item{k_subpops}{If \code{inbr_subpops} is a scalar, optionally provide the desired number of subpopulations (lest a single subpopulation be simulated).
Stops if both \code{length(inbr_subpops) > 1} and \code{k_subpops} is not \code{NA} and they disagree.}
}
\value{
The \code{m_loci}-by-\code{k_subpops} matrix of independent subpopulation allele frequencies.
If \code{p_anc} is length-\code{m_loci} with names, these are copied to the row names of this output matrix.
If \code{inbr_subpops} is length-\code{k_subpops} with names, these are copied to the column names of this output matrix.
}
\description{
The allele frequency matrix \code{P} for \code{m_loci} loci (rows) and \code{k_subpops} independent subpopulations (columns) are drawn from the Balding-Nichols distribution with ancestral allele frequencies \code{p_anc} and FST parameters \code{inbr_subpops} equivalent to
\code{P[ i, j ] <- rbeta( 1, nu_j * p_anc[i], nu_j * ( 1 - p_anc[i] ) )},
where \code{nu_j <- 1 / inbr_subpops[j] - 1}.
The actual function is more efficient than the above code.
}
\examples{
# a typical, non-trivial example
# number of loci
m_loci <- 10
# random vector of ancestral allele frequencies
p_anc <- draw_p_anc(m_loci)
# FST values for two subpops
inbr_subpops <- c(0.1, 0.3)
# matrix of intermediate subpop allele freqs
p_subpops <- draw_p_subpops(p_anc, inbr_subpops)

# special case of scalar p_anc
p_subpops <- draw_p_subpops(p_anc = 0.5, inbr_subpops, m_loci = m_loci)
stopifnot ( nrow( p_subpops ) == m_loci )

# special case of scalar inbr_subpops
k_subpops <- 2
p_subpops <- draw_p_subpops(p_anc, inbr_subpops = 0.2, k_subpops = k_subpops)
stopifnot ( ncol( p_subpops ) == k_subpops )

# both main parameters scalars but return value still matrix
p_subpops <- draw_p_subpops(p_anc = 0.5, inbr_subpops = 0.2, m_loci = m_loci, k_subpops = k_subpops)
stopifnot ( nrow( p_subpops ) == m_loci )
stopifnot ( ncol( p_subpops ) == k_subpops )

# passing scalar parameters without setting dimensions separately results in a 1x1 matrix
p_subpops <- draw_p_subpops(p_anc = 0.5, inbr_subpops = 0.2)
stopifnot ( nrow( p_subpops ) == 1 )
stopifnot ( ncol( p_subpops ) == 1 )

}
\seealso{
\code{\link[=draw_p_subpops_tree]{draw_p_subpops_tree()}} for version for subpopulations related by a tree, which can therefore be non-independent.
}
