% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.ordered.to.pa.R
\name{check.ordered.to.pa}
\alias{check.ordered.to.pa}
\title{Verifies if there are ordered factor variables to be declared in the pa model building process}
\usage{
check.ordered.to.pa(bn.structure, data.to.work)
}
\arguments{
\item{bn.structure}{is a BN structure learned from data used to identify if the variable is endogenous or exogenous when building the PA model.}

\item{data.to.work}{is a data set containing the variables of the BN.}
}
\value{
a data frame with ordered variables.
}
\description{
Receives a BN structure and a data set, then verifies if there are ordered variables. In a positive case return TRUE.
}
\examples{
# Clean environment
closeAllConnections()
rm(list=ls())
# Set enviroment
# setwd("~/your working directory")
# Load packages
library(bnpa)
# Load the dataset
data(dataQualiN) # Pre-Loaded
# Build the BN structure
bn.structure<-bnlearn::hc(dataQualiN)
# Show the BN structure learned
bnlearn::graphviz.plot(bn.structure)
# Tranforms variables A and B in ordered factor
dataQualiN$A <- as.ordered(dataQualiN$A)
dataQualiN$B <- as.ordered(dataQualiN$B)
# Generates a list with variables to be ordered and exogenous variables
cat.var.to.use.in.pa <- bnpa::check.ordered.to.pa(bn.structure, dataQualiN)
# Show the variables
cat.var.to.use.in.pa
}
\references{
HAYES, A F; PREACHER, K J. Statistical mediation analysis with a multicategorical independent variable. British Journal of Mathematical and Statistical Psychology, v. 67, n. 3, p. 451-470, 2014.
}
\author{
Elias Carvalho
}
