% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_m3.R
\name{m3}
\alias{m3}
\title{The Multinomial / Memory Measurement Model}
\usage{
m3(resp_cats, num_options, choice_rule = "softmax", version = "custom", ...)
}
\arguments{
\item{resp_cats}{The variable names that contain the number of responses for each of the
response categories used for the M3.}

\item{num_options}{Either an integer vector of the same length as \code{resp_cats} if the number
of candidates in the respective response categories are constant across all conditions
in the experiment. Or a vector specifying the variable names that contain the number of
candidates in each response category. The order of these variables should be in the
same order as the names of the response categories passed to \code{resp_cats}}

\item{choice_rule}{The choice rule that should be used for the M3. The options are "softmax"
or "simple". The "softmax" option implements the softmax normalization of activation into
probabilities for choosing the different response categories. The "simple" option implements
a simple normalization of the absolute activations over the sum of all activations. For details
on the differences of these choice rules please see the appendix of Oberauer & Lewandowsky (2019)
"Simple measurement models for complex working memory tasks" published in Psychological Review.}

\item{version}{Character. The version of the M3 model to use. Can be one of
\code{ss}, \code{cs}, or \code{custom}. The default is \code{custom}.}

\item{...}{used internally for testing, ignore it}
}
\value{
An object of class \code{bmmodel}
}
\description{
The Multinomial / Memory Measurement Model (M3) is a measurement model that was originally introduced
for working memory tasks with categorical responses. It assumes that each candidate in each response
category is activated by a combination of sources of activation. The probability of choosing a response
category is determined by the activation of the candidates. The model can be used for any n-AFC categorical
decision task.
}
\details{
\itemize{
\item \strong{Domain:} Working Memory (categorical), Categorical Decision Making
\item \strong{Task:} n-AFC retrieval
\item \strong{Name:} The Multinomial / Memory Measurement Model
\item \strong{Citation:}
\itemize{
\item Oberauer, K., & Lewandowsky, S. (2019). Simple measurement models for complex working-memory tasks. Psychological Review, 126.
}
}
\subsection{Version: \code{ss}}{
\itemize{
\item \strong{Requirements:}
\itemize{
\item Provide names for variables specifying the number of responses in a set of response categories.
\item Specify activation sources for each response categories
\item Include at least an activation source "b" for all response categories
\item Predict the specified activation at least by a fixed intercept and any additional predictors from your data
}
\item \strong{Parameters:}
\itemize{
\item \code{b}: Background activation. Added to each response category. Fixed for scaling, necessary in all models.
\item \code{c}: Context activation. Added to the item cued to be recalled, that is the correct item.
\item \code{a}: General activation. Added to all items that were presented during the current trial.
}
\item \strong{Fixed parameters:}
\itemize{
\item \code{b} = 0
}
\item \strong{Default parameter links:}
\itemize{
\item c = identity; a = identity
}
\item \strong{Default priors:}
\itemize{
\item \code{a}:
\itemize{
\item \code{main}: normal(2,1)
\item \code{effects}: normal(0,0.5)
}
\item \code{c}:
\itemize{
\item \code{main}: normal(3,1)
\item \code{effects}: normal(0,2)
}
}
}
}

\subsection{Version: \code{cs}}{
\itemize{
\item \strong{Requirements:}
\itemize{
\item Provide names for variables specifying the number of responses in a set of response categories.
\item Specify activation sources for each response categories
\item Include at least an activation source "b" for all response categories
\item Predict the specified activation at least by a fixed intercept and any additional predictors from your data
}
\item \strong{Parameters:}
\itemize{
\item \code{b}: Background activation. Added to each response category. Fixed for scaling, necessary in all models.
\item \code{c}: Context activation. Added to the item cued to be recalled, that is the correct item.
\item \code{a}: General activation. Added to all items that were presented during the current trial.
\item \code{f}: Filtering. This parameter captures the extent to which distractors remained in working memory.
}
\item \strong{Fixed parameters:}
\itemize{
\item \code{b} = 0
}
\item \strong{Default parameter links:}
\itemize{
\item c = identity; a = identity; f = logit
}
\item \strong{Default priors:}
\itemize{
\item \code{a}:
\itemize{
\item \code{main}: normal(3,1)
\item \code{effects}: normal(0,0.5)
}
\item \code{c}:
\itemize{
\item \code{main}: normal(3,1)
\item \code{effects}: normal(0,2)
}
\item \code{f}:
\itemize{
\item \code{main}: logistic(0,1)
\item \code{effects}: normal(0,1)
}
}
}
}

\subsection{Version: \code{custom}}{
\itemize{
\item \strong{Requirements:}
\itemize{
\item Provide names for variables specifying the number of responses in a set of response categories.
\item Specify activation sources for each response categories
\item Include at least an activation source "b" for all response categories
\item Predict the specified activation at least by a fixed intercept and any additional predictors from your data
}
\item \strong{Parameters:}
\itemize{
\item \code{b}: Background activation. Added to each response category. Fixed for scaling, necessary in all models.
}
\item \strong{Fixed parameters:}
\itemize{
\item \code{b} = 0
}
\item \strong{Default parameter links:}
\itemize{
\item =
}
\item \strong{Default priors:}
}
}
}
\examples{
\dontshow{if (isTRUE(Sys.getenv("BMM_EXAMPLES"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data <- oberauer_lewandowsky_2019_e1

# initiate the model object
m3_model <- m3(
  resp_cats = c("corr", "other", "dist", "npl"),
  num_options = c("n_corr", "n_other", "n_dist", "n_npl"),
  choice_rule = "simple"
)

# specify the model formula including the activation formulas for each response category
m3_formula <- bmf(
  corr ~ b + a + c,
  other ~ b + a,
  dist ~ b + d,
  npl ~ b,
  c ~ 1 + cond + (1 + cond | ID),
  a ~ 1 + cond + (1 + cond | ID),
  d ~ 1 + (1 | ID)
)

# specify links for the model parameters
m3_model$links <- list(
  c = "log",
  a = "log",
  d = "log"
)

# check if the default priors are applied correctly
default_prior(m3_formula, data = data, model = m3_model)

# fit the model
m3_fit <- bmm(
  formula = m3_formula,
  data = data,
  model = m3_model,
  cores = 4
)

# print summary of the model
summary(m3_fit)
\dontshow{\}) # examplesIf}
}
\keyword{bmmodel}
