% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ResultsFollowupAnalysisAndPlotting.R
\name{GetModelPriorMatrix}
\alias{GetModelPriorMatrix}
\title{Get Model Prior Matrix}
\usage{
GetModelPriorMatrix(DataSources, Models, ModelPriors, LogFile,
  SigmaAlphas = c(0.005, 0.0075, 0.01, 0.015, 0.02, 0.03, 0.04, 0.05,
  0.06, 0.07, 0.08, 0.09, 0.1, 0.15))
}
\arguments{
\item{DataSources}{A string indicating the variable names of the
input datafiles and phenotypes.}

\item{Models}{A matrix describing the models being explored
(default output from running \code{\link{bmass}}).}

\item{ModelPriors}{A vector containing the priors on each model
across each tranche of sigma alpha (default output from running
\code{\link{bmass}}; length is number of models times number of 
sigma alphas).}

\item{LogFile}{A matrix of string outputs for function logging
purposes (default output from running \code{\link{bmass}}).}

\item{SigmaAlphas}{A vector containing the different values
traversed for this 'effect size controlling' hyperparameter (see
"Prior on Sigma_Alpha" in Stephens 2013 PLoS ONE, 
\url{https://doi.org/10.1371/journal.pone.0065245}).}
}
\value{
A matrix containing the original description of each model
sort by prior, each model's trained prior, the cummulative prior
distribution, and the model's original order position.
}
\description{
Creates a matrix containing the model descriptions and
their associated priors.
}
\examples{
Phenotypes <- c("bmass_SimulatedData1", "bmass_SimulatedData2")
bmassOutput <- bmass(Phenotypes,bmass_SimulatedSigSNPs)
bmassOutput[c("ModelPriorMatrix", "LogFile")] <- 
  GetModelPriorMatrix(Phenotypes, bmassOutput$Models,
  bmassOutput$ModelPriors, bmassOutput$LogFile)
head(bmassOutput$ModelPriorMatrix)

}
