% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-serdes.R
\name{blockr_ser}
\alias{blockr_ser}
\alias{blockr_ser.block}
\alias{blockr_ser.blocks}
\alias{blockr_ser.board_options}
\alias{blockr_ser.blockr_ctor}
\alias{blockr_ser.board_option}
\alias{blockr_ser.llm_model_option}
\alias{blockr_ser.board}
\alias{blockr_ser.link}
\alias{blockr_ser.links}
\alias{blockr_ser.stack}
\alias{blockr_ser.stacks}
\alias{blockr_deser}
\alias{blockr_deser.list}
\alias{blockr_deser.block}
\alias{blockr_deser.blocks}
\alias{blockr_deser.board}
\alias{blockr_deser.link}
\alias{blockr_deser.links}
\alias{blockr_deser.stack}
\alias{blockr_deser.stacks}
\alias{blockr_deser.board_options}
\alias{blockr_deser.blockr_ctor}
\alias{blockr_deser.board_option}
\title{Serialization utilities}
\usage{
blockr_ser(x, ...)

\method{blockr_ser}{block}(x, state = NULL, ...)

\method{blockr_ser}{blocks}(x, blocks = NULL, ...)

\method{blockr_ser}{board_options}(x, options = NULL, ...)

\method{blockr_ser}{blockr_ctor}(x, ...)

\method{blockr_ser}{board_option}(x, option = NULL, ...)

\method{blockr_ser}{llm_model_option}(x, option = NULL, ...)

\method{blockr_ser}{board}(x, board_id = NULL, ...)

\method{blockr_ser}{link}(x, ...)

\method{blockr_ser}{links}(x, ...)

\method{blockr_ser}{stack}(x, ...)

\method{blockr_ser}{stacks}(x, ...)

blockr_deser(x, ...)

\method{blockr_deser}{list}(x, ...)

\method{blockr_deser}{block}(x, data, ...)

\method{blockr_deser}{blocks}(x, data, ...)

\method{blockr_deser}{board}(x, data, ...)

\method{blockr_deser}{link}(x, data, ...)

\method{blockr_deser}{links}(x, data, ...)

\method{blockr_deser}{stack}(x, data, ...)

\method{blockr_deser}{stacks}(x, data, ...)

\method{blockr_deser}{board_options}(x, data, ...)

\method{blockr_deser}{blockr_ctor}(x, data, ...)

\method{blockr_deser}{board_option}(x, data, ...)
}
\arguments{
\item{x}{Object to (de)serialize}

\item{...}{Generic consistency}

\item{state}{Object state (as returned from an \code{expr_server})}

\item{blocks}{Block states (\code{NULL} defaults to values from ctor scope)}

\item{options}{Board option values (\code{NULL} uses values provided by \code{x})}

\item{option}{Board option value (\code{NULL} uses values provided by \code{x})}

\item{board_id}{Board ID}

\item{data}{List valued data (converted from JSON)}
}
\value{
Serialization helper function \code{blockr_ser()} returns lists, which
for most objects contain slots \code{object} and \code{payload}, where \code{object}
contains a class vector which is used by \code{blockr_deser()} to instantiate an
empty object of that class and use S3 dispatch to identify the correct method
that, given the content in \code{payload}, can re-create the original object.
}
\description{
Blocks are serialized by writing out information on the constructor used to
create the object, combining this with block state information, which
constitutes values such that when passed to the constructor the original
object can be re-created.
}
\details{
Helper functions \code{blockr_ser()} and \code{blockr_deser()} are implemented as
generics and perform most of the heavy lifting for (de-)serialization:
representing objects as easy-to-serialize (nested) lists containing mostly
strings and no objects which are hard/impossible to truthfully re-create in
new sessions (such as environments).
}
\examples{
blk <- new_dataset_block("iris")

blockr_ser(blk)

all.equal(blk, blockr_deser(blockr_ser(blk)), check.environment = FALSE)

}
