% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simgamdata.R
\name{simgamdata}
\alias{simgamdata}
\title{Simulation of data for (Generalized) additive models.}
\usage{
simgamdata(setting = 1, n, dist = "gaussian", scale = 0.5, info = TRUE)
}
\arguments{
\item{setting}{The simulation setting. The default is \code{setting = 1}
for a setting with three smooth terms, while \code{setting = 2} is another
setting with only two smooth terms. The coefficients of the linear part
of the predictor are also different in the two settings.}

\item{n}{The sample size to simulate.}

\item{dist}{A character string to specify the response distribution. The
default is \code{"gaussian"}. Other distributions can be \code{"poisson"},
\code{"bernoulli"} and \code{"binomial"}.}

\item{scale}{Used to tune the noise level for Gaussian and Poisson
distributions.}

\item{info}{Should information regarding the simulation be printed?
Default is true.}
}
\value{
An object of class \emph{simgam}. Plot of a \emph{simgam} object
 yields a scatter plot of the generated response values.

\item{data}{A data frame.}

\item{f}{The true smooth functions.}

\item{betas}{The regression coefficients of the linear part. The first
 term is the intercept.}

\item{dist}{The distribution of the response.}
}
\description{
Simulation of a data set that can be used to illustrate the
\code{\link{amlps}} or \code{\link{gamlps}} routines to fit
(generalized) additive models with the Laplace-P-spline methodology.
}
\details{
The simulation settings contain two covariates in the linear part
 of the predictor, namely \emph{z1 ~ Bern(0.5)} and \emph{z2 ~ N(0,1)}. The
 smooth additive terms are inspired from Antoniadis et al. (2012).
 For Binomial data, the number of trials is fixed to 15.
}
\examples{
set.seed(10)
sim <- simgamdata(n = 150, dist = "poisson", scale = 0.3)
plot(sim)

}
\references{
Antoniadis, A., Gijbels, I., and Verhasselt, A. (2012). Variable
 selection in additive models using P-splines. \emph{Technometrics}
 \strong{54}(4): 425-438.
}
\author{
Oswaldo Gressani \email{oswaldo_gressani@hotmail.fr}.
}
