% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3_curelps_print.R
\name{print.curelps}
\alias{print.curelps}
\title{Print the fit of a promotion time cure model.}
\usage{
\method{print}{curelps}(x, ...)
}
\arguments{
\item{x}{An object of class \code{curelps}.}

\item{...}{Further arguments to be passed to print.}
}
\description{
Print method for a \code{curelps} object.
}
\details{
{Prints informative output of a fitted promotion time cure model
 with the Laplace-P-spline approach. In particular, the model formula,
 number of B-splines in basis, chosen penalty order, latent field
 dimension, sample size, number of events and effective model dimension
 are provided. The estimated model coefficients related to the
 cure probability (long-term survival) and the population hazard dynamics
 (short-term survival) are also provided, where \code{coef} is
 the point estimate, \code{sd.post} the posterior standard deviation,
 \code{z} is the Wald test statistic and \code{lower.95} and
 \code{upper.95} the lower, respectively upper bounds of the approximate
 95\% pointwise credible interval.}
}
\seealso{
\code{\link{curelps}}, \code{\link{curelps.extract}},
 \code{\link{plot.curelps}}
}
\author{
Oswaldo Gressani \email{oswaldo_gressani@hotmail.fr}.
}
