% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ComputeMixtureSummaries.R
\name{OverallRiskSummaries}
\alias{OverallRiskSummaries}
\title{Calculate overall risk summaries}
\usage{
OverallRiskSummaries(
  fit,
  y = NULL,
  Z = NULL,
  X = NULL,
  qs = seq(0.25, 0.75, by = 0.05),
  q.fixed = 0.5,
  method = "approx",
  sel = NULL
)
}
\arguments{
\item{fit}{An object containing the results returned by a the \code{kmbayes} function}

\item{y}{a vector of outcome data of length \code{n}.}

\item{Z}{an \code{n}-by-\code{M} matrix of predictor variables to be included in the \code{h} function. Each row represents an observation and each column represents an predictor.}

\item{X}{an \code{n}-by-\code{K} matrix of covariate data where each row represents an observation and each column represents a covariate. Should not contain an intercept column.}

\item{qs}{vector of quantiles at which to calculate the overall risk summary}

\item{q.fixed}{a second quantile at which to compare the estimated \code{h} function}

\item{method}{method for obtaining posterior summaries at a vector of new points. Options are "approx" and "exact"; defaults to "approx", which is faster particularly for large datasets; see details}

\item{sel}{selects which iterations of the MCMC sampler to use for inference; see details}
}
\value{
a data frame containing the (posterior mean) estimate and posterior standard deviation of the overall risk measures
}
\description{
Compare estimated \code{h} function when all predictors are at a particular quantile to when all are at a second fixed quantile
}
\details{
\itemize{
  \item If \code{method == "approx"}, the argument \code{sel} defaults to the second half of the MCMC iterations.
  \item If \code{method == "exact"}, the argument \code{sel} defaults to keeping every 10 iterations after dropping the first 50\% of samples, or if this results in fewer than 100 iterations, than 100 iterations are kept
}
For guided examples and additional information, go to \url{https://jenfb.github.io/bkmr/overview.html}
}
\examples{
## First generate dataset
set.seed(111)
dat <- SimData(n = 50, M = 4)
y <- dat$y
Z <- dat$Z
X <- dat$X

## Fit model with component-wise variable selection
## Using only 100 iterations to make example run quickly
## Typically should use a large number of iterations for inference
set.seed(111)
fitkm <- kmbayes(y = y, Z = Z, X = X, iter = 100, verbose = FALSE, varsel = TRUE)

risks.overall <- OverallRiskSummaries(fit = fitkm, qs = seq(0.25, 0.75, by = 0.05), 
q.fixed = 0.5, method = "exact")
}
