% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Extract.bm_matrix.R
\name{[.bm_matrix}
\alias{[.bm_matrix}
\alias{[.bm_bitmap}
\alias{[.bm_pixmap}
\alias{[<-.bm_bitmap}
\alias{[<-.bm_pixmap}
\title{Extract or replace parts of a bitmap/pixmap matrix}
\usage{
\method{[}{bm_matrix}(x, i, j, ..., drop = TRUE)

\method{[}{bm_bitmap}(x, i, j, ...) <- value

\method{[}{bm_pixmap}(x, i, j, ...) <- value
}
\arguments{
\item{x}{\code{\link[=bm_bitmap]{bm_bitmap()}} object}

\item{i, j}{indices specifying elements to extract or replace.
See [base::\verb{[()}] for more information.}

\item{...}{Passed to [base::\verb{[()}].}

\item{drop}{If \code{TRUE} the result is coerced to a integer vector.}

\item{value}{Replacement value}
}
\value{
\verb{[.bm_matrix()} returns a \code{\link[=bm_bitmap]{bm_bitmap()}} or \code{\link[=bm_pixmap]{bm_pixmap()}} object if the
value is a matrix and/or \code{drop} is \code{FALSE}
otherwise it returns a vector of integers or color strings.
}
\description{
\verb{[.bm_matrix()} is defined so that it returns a \code{\link[=bm_bitmap]{bm_bitmap()}} or \code{\link[=bm_pixmap]{bm_pixmap()}} object
(if the value is a matrix).
\verb{[<-.bm_bitmap()} casts any replacement values as integers while
\verb{[<-.bm_pixmap()} casts any replacement values as standardized color strings.
}
\examples{
 font_file <- system.file("fonts/spleen/spleen-8x16.hex.gz", package = "bittermelon")
 font <- read_hex(font_file)
 capital_r <- font[[str2ucp("R")]]
 print(capital_r[4:14,2:8])
 capital_r[11:13,3:5] <- 2L
 print(capital_r)
}
