% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ability.R
\name{ability}
\alias{ability}
\title{Ability Estimation}
\usage{
ability(mdl, u, b, a, c)
}
\arguments{
\item{mdl}{1, 2, or 3 representing the number of the model parameters.}

\item{u}{a numeric vector of 0s and 1s representing the responses to items.}

\item{b}{a numeric vector representing the values of item difficulty.}

\item{a}{a numeric vector representing the values of item discrimination.}

\item{c}{a numeric vector representing the values of lower asymptote.}
}
\description{
Estimates the ability parameter and obtains the standard error of the
estimate given the item characteristic curve model, the response vector,
and the set of known item parameters under the one-, two-, or
three-parameter logistic model.
}
\details{
With the number of item characteristic curve model parameters \code{mdl},
the response vector \code{u}, and the set of item parameters \code{b},
\code{a}, and \code{c}, the ability parameter is estimated and reported
as \code{th} by the maximum likelilhood procedure.
The estimated standard error \code{se} is also obtained and reported.
The length of \code{u} should be the same as that of \code{b}, \code{a},
and \code{c}.
Each parameter \code{c} has a theoretical range from 0 to 1, but in
practice values above .35 are not considered acceptable, hence use the
range from 0 to .35 for each \code{c}.
Under the one-parameter logisric model, \code{a = rep(1, length(b))} and
\code{c = rep(0, length(b))}.
Under the two-parameter logistic model, \code{c = rep(0, lenght(b))}.
}
\examples{
u <- c(1, 0, 1)
b <- c(-1.0, 0.0, 1.0)
a <- c(1.0, 1.2, 0.8)
ability(2, u, b, a) # ability(2, u, b, a, c = rep(0, length(b)))
theta.se <- ability(2, u, b, a)
theta.se
}
\references{
Baker, F. B., & Kim, S.-H. (2017).
\emph{The basics of item response theory using R.}
New York, NY: Springer.
ISBN-13: 978-3-319-54204-1
}
\keyword{groupinv}
