% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sniff_groups_cumulative.R
\name{sniff_groups_cumulative}
\alias{sniff_groups_cumulative}
\title{Analyze Cumulative Network Groups Over Time}
\usage{
sniff_groups_cumulative(
  comps,
  time_span = NULL,
  min_group_size = 10,
  keep_component = c("c1"),
  cluster_component = c("c1"),
  top_n_keywords = 10,
  algorithm = "fast_greedy",
  seed = 888L
)
}
\arguments{
\item{comps}{A list containing network components, typically generated by
\code{\link{sniff_components}}(). Must include a network object with
'component' and 'PY' (publication year) vertex attributes.}

\item{time_span}{Numeric vector of years to analyze (default: 2000:2024).}

\item{min_group_size}{Minimum size for a cluster to be retained (default = 10).}

\item{keep_component}{Character vector specifying which network components to
process (default = "c1"). Can include multiple components.}

\item{cluster_component}{Character vector specifying which components should be
clustered (default = "c1"). Components not listed here will be treated
as single groups.}

\item{top_n_keywords}{Number of top keywords to extract per group (default = 10).}

\item{algorithm}{Community detection algorithm to use. One of:
\code{"louvain"}, \code{"walktrap"}, \code{"edge_betweenness"},
\code{"fast_greedy"} (default), or \code{"leiden"}.}

\item{seed}{Random seed for reproducible results (default = 888L). Only applies
to algorithms that use random initialization like Louvain.}
}
\value{
A named list (by year) where each element contains:
\describe{
\item{groups}{A tibble with group statistics and top keywords}
\item{documents}{A tibble mapping documents to groups}
\item{network}{The cumulative network up to that year}
}
}
\description{
Performs cumulative community detection on a network over specified time spans,
returning group statistics and keyword analysis for each time period.
}
\examples{
\dontrun{
# Typical pipeline:
data <- read_wos("savedrecs.txt")
net <- sniff_network(data)
comps <- sniff_components(net)

# Cumulative analysis
groups_cumulative <- sniff_groups_cumulative(
  comps,
  time_span = 2010:2020,
  keep_component = c("c1", "c2"),
  cluster_component = c("c1"),
  algorithm = "leiden",
  seed = 888L
)

# Access results for 2015
groups_cumulative[["network_until_2015"]]$groups
}

}
