% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.r
\name{calcRiffle}
\alias{calcRiffle}
\title{Calculate Whalley 'Riffle' habitat-specific BMWP indices for invertebrate
samples}
\usage{
calcRiffle(df, type = "num")
}
\arguments{
\item{df}{A dataframe containing list of taxa in first column, followed by
columns of abundances with sample names in header row.}

\item{type}{Indicates format of data. Options are "num" for numeric data,
"log" for integer log abundance categories (1-5) or "alpha" for alphabetic
abundance categories (A-E). Default value is "num".}
}
\value{
A data frame consisting of columns of index values with samples
in rows.
}
\description{
Calculates Whalley riffle-specific BMWP, ASPT and N-taxa
indices for invertebrate samples.
}
\examples{

# calculate the Whalley Riffle BMWP indices for the Braid Burn dataset
# data are alphabetic log abundance categories, so type is "alpha"

calcRiffle(braidburn, "alpha")
}

