% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bin2norm.R
\name{estimate_multiThresh_GLMM}
\alias{estimate_multiThresh_GLMM}
\title{GLMM (Multiple Thresholds per Study, Probit Link, Random Intercepts)}
\usage{
estimate_multiThresh_GLMM(data_list, use_lme4 = TRUE)
}
\arguments{
\item{data_list}{same structure: \code{n_i}, \code{c_ij}, \code{p_ij_obs}}

\item{use_lme4}{logical; if \code{TRUE}, calls \code{lme4::glmer} with a probit link.}
}
\value{
A list with \code{mu0}, \code{sigma}, \code{tau}, \code{method="GLMM_probit"}.
}
\description{
Creates a single data frame stacking all thresholds from all studies, then
calls \code{lme4::glmer(..., family=binomial(link='probit'))} to fit a random-intercept
model:
\deqn{k_{ij} \sim \mathrm{Binomial}\bigl(n_i, \Phi(\alpha_i + \beta\, c_{ij})\bigr),}
with \eqn{\alpha_i \sim \mathcal{N}(0, \sigma_\alpha^2)}.

Interpreting results: \eqn{\sigma = 1/|\,\beta\,|},
\eqn{\tau^2 = \sigma^2 \times \sigma_\alpha^2},
\eqn{\mu_0 = (\mathrm{Intercept}) \times \sigma} (if not forced to 0).
}
