% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca_interface.R
\name{prepare_svd_robust_input}
\alias{prepare_svd_robust_input}
\title{Prepare iteratively reweighted singular value decomposition}
\usage{
prepare_svd_robust_input(x, ncomp, max_iter, tol, huber_k)
}
\arguments{
\item{x}{Numeric matrix for which the decomposition should be computed.}

\item{ncomp}{Number of leading components to retain.}

\item{max_iter}{Maximum number of reweighting iterations.}

\item{tol}{Convergence tolerance applied to successive changes in the row
weights and singular values.}

\item{huber_k}{Tuning constant controlling the aggressiveness of the Huber
weight function. Larger values down-weight fewer observations.}
}
\value{
A list containing x, n, p, ncomp, max_iter, tol and huber_k.
}
\description{
Internal helper used by \code{\link[=pca_robust]{pca_robust()}} to compute a singular value
decomposition that is less sensitive to individual rows with extreme values.
The routine alternates between computing the SVD of a row-weighted matrix and
updating the weights via a Huber-type scheme based on the reconstruction
residuals.
}
\keyword{internal}
