% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/telemetry_otel_conversion.R
\name{calculate_span_duration_ms}
\alias{calculate_span_duration_ms}
\title{Calculate span duration in milliseconds}
\usage{
calculate_span_duration_ms(start_time, end_time)
}
\arguments{
\item{start_time}{POSIXct start timestamp}

\item{end_time}{POSIXct end timestamp}
}
\value{
Numeric duration in milliseconds, or NA if either time is missing
}
\description{
Computes the duration between span start and end times in milliseconds.
}
\examples{
\dontrun{
start <- as.POSIXct("2024-01-01 12:00:00", tz = "UTC")
end <- as.POSIXct("2024-01-01 12:00:01.5", tz = "UTC")
calculate_span_duration_ms(start, end) # returns 1500
}
}
\keyword{internal}
