% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mock_bids.R
\name{tasks.mock_bids_project}
\alias{tasks.mock_bids_project}
\title{Get Tasks from Mock BIDS Project}
\usage{
\method{tasks}{mock_bids_project}(x, ...)
}
\arguments{
\item{x}{A \code{mock_bids_project} object.}

\item{...}{Extra arguments (ignored).}
}
\value{
Character vector of unique task names (e.g., c("rest", "nback")), sorted.
}
\description{
Extracts the unique task names found in the mock project's file structure.
Note: Returns names \emph{without} the "task-" prefix.
}
\examples{
# Create a mock project with tasks
parts <- data.frame(participant_id = "01")
fs <- data.frame(subid="01", task="taskA", run="01", datatype="func", 
                 suffix="bold.nii.gz", fmriprep=FALSE)
fs <- rbind(fs, data.frame(subid="01", task="taskB", run="01", datatype="func", 
                          suffix="bold.nii.gz", fmriprep=FALSE))
mock_proj <- create_mock_bids("TaskMock", parts, fs)

# Get task names
tasks(mock_proj)
}
