% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generic.R, R/bids.R
\name{bids_check_compliance}
\alias{bids_check_compliance}
\title{Basic BIDS Compliance Checks}
\usage{
bids_check_compliance(x)

bids_check_compliance(x)
}
\arguments{
\item{x}{A \code{bids_project} object.}
}
\value{
A list with compliance check results

A list with:
\itemize{
\item \code{passed} (logical): TRUE if all checks passed, FALSE otherwise.
\item \code{issues} (character vector): Descriptions of any issues found.
}
}
\description{
This function performs a simple, lightweight check of common BIDS requirements:
\itemize{
\item Checks that \code{participants.tsv} and \code{dataset_description.json} exist at the root.
\item Ensures all subject directories begin with \verb{sub-}.
\item If sessions are present, ensures that session directories begin with \verb{ses-}.
}
}
\details{
Note: This is not a full BIDS validator. For complete validation, use the
official BIDS validator.
}
\examples{
\donttest{
tryCatch({
  ds001_path <- get_example_bids_dataset("ds001")
  proj <- bids_project(ds001_path)
  compliance <- bids_check_compliance(proj)
  
  # Clean up
  unlink(ds001_path, recursive=TRUE)
}, error = function(e) {
  message("Example requires internet connection: ", e$message)
})
}
}
