% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_biblioscopus.R
\name{convert_biblioscopus}
\alias{convert_biblioscopus}
\title{Function that converts the BibTeX format from the Scopus database to a CSV spreadsheet.}
\usage{
convert_biblioscopus(variavel1, variavel2)
}
\arguments{
\item{variavel1}{is the database that contains the input and output keys for metadata in Bibtex format for articles in the Scopus collection.}

\item{variavel2}{is the database that contains the metadata in Bibtex format for articles in the Scopus collection.}
}
\value{
This function returns a dataframe containing the metadata for the articles in the Scopus collection.
}
\description{
The function converts the Scopus database metadata file from Bibtex format to a CSV spreadsheet. The function's input is a file with the .bib extension. The function returns a dataframe.
}
\examples{

#Call the convert_biblioscopus function

file_db <- system.file("extdata","scopus.bib", package = "bibliorefer")
cabec = TRUE
quoaspa = ""
base_scopus <- entrada_scopus(file_db, cabec, quoaspa)
base_scopus <- as.data.frame(base_scopus)
variavel1 <- base_scopus$V1
variavel2 <- base_scopus$V2

#Call the convert_biblioscopus function
font_scopus <- convert_biblioscopus(variavel1,variavel2)
font_scopus



}
\references{
Aria, M. & Cuccurullo, C. (2017) bibliometrix: An R-tool for comprehensive science mapping analysis, Journal of Informetrics, 11(4), pp 959-975, Elsevier
}
