% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize_documents.R
\name{visualize_documents}
\alias{visualize_documents}
\title{Visualize Documents in Reduced Embedding Space}
\usage{
visualize_documents(
  model = topic_model,
  texts = texts_cleaned,
  reduced_embeddings = reduced_embeddings,
  custom_labels = FALSE,
  hide_annotation = TRUE,
  filename = "visualize_documents",
  auto_open = FALSE
)
}
\arguments{
\item{model}{A BERTopic model object. Default is 'topic_model'.}

\item{texts}{A list or vector of cleaned text documents to visualize. Default is 'texts_cleaned'.}

\item{reduced_embeddings}{A matrix of reduced-dimensionality embeddings. Typically generated using UMAP. Default is 'reduced_embeddings'.}

\item{custom_labels}{A logical value indicating whether to use custom labels for topics. Default is FALSE.}

\item{hide_annotation}{A logical value indicating whether to hide annotations in the plot. Default is TRUE.}

\item{filename}{A string specifying the name of the HTML file to save the visualization. Default is "visualize_documents".}

\item{auto_open}{A logical value indicating whether to automatically open the HTML file after saving. Default is FALSE.}
}
\value{
A Plotly visualization of the documents, displayed as an HTML file within the R environment.
}
\description{
This function generates a visualization of documents using a pre-trained BERTopic model.
It uses UMAP to reduce the dimensionality of embeddings and Plotly for interactive visualizations.
}
\examples{
\donttest{
if (exists("topic_model") && exists("texts_cleaned") && exists("reduced_embeddings")) {
  visualize_documents(model = topic_model,
                      texts = texts_cleaned,
                      reduced_embeddings = reduced_embeddings,
                      custom_labels = FALSE,
                      hide_annotation = TRUE,
                      filename = "visualize_documents",
                      auto_open = FALSE)
} else {
  message("Missing topic_model/texts_cleaned/reduced_embeddings. Train a model first.")
}
}
}

